package easik.ui.tree;

import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Tree node used for items that are forced to not be leaf.
 * 
 * @author Kevin Green 2006
 * @since 2006-06-14 Kevin Green
 * @version 2006-06-14 Kevin Green
 */
public class NonLeafNode extends DefaultMutableTreeNode {
	
	/**
	 * Default constructor
	 * 
	 * @param inObj Object to be passed to superclass
	 */
	public NonLeafNode(Object inObj){
		super(inObj);
	}
	
	/**
	 * Overwritten method to create a node that can never be a leaf
	 * @return Always return false because it is being forced to be a non leaf node
	 */
	public boolean isLeaf(){
		return false;
	}
}
